/*------------------------------------------------------
Convert from AVI to qcif(cif)

made by Shaowei Chen ( chen_sw@email.com )
  ------------------------------------------------------*/

#include <windows.h>
#include <stdio.h>
#include <commdlg.h>
#include <vfw.h>

#include "resource.h"
#include "MYDIB.h"

typedef struct fileData {
char fileName[MAX_PATH];
char mpegFilename[MAX_PATH];
PAVIFILE pfile;
PAVISTREAM pavi_video;
PGETFRAME pgf;
AVISTREAMINFO videoInfo;
AVIFILEINFO fileInfo;
BITMAPINFO *bitmapInfo;
MYDIB *pmydib;
bool aviFile;
}FILEDATA;

int DisplayMBox(char *txt, char *title);
void initFILEDATA(FILEDATA *files);
bool OpenAVI(FILEDATA *files);
bool getFrame(FILEDATA *files,long currentOPos);
bool ResizeFrame(FILEDATA *files,int cx,int cy);
bool CloseAVI(FILEDATA *files);

BOOL CALLBACK DlgProc (HWND, UINT, WPARAM, LPARAM) ;
BOOL    CALLBACK ColorScrDlg (HWND, UINT, WPARAM, LPARAM) ;
TCHAR szAppName [] = TEXT ("IDD_DIALOG1") ;
char errortext[MAX_PATH];
HWND ghwnd;


int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    PSTR szCmdLine, int iCmdShow)
{

	if (-1 == DialogBox (hInstance, "IDD_DIALOG1", NULL, DlgProc))
     {
          MessageBox (NULL, TEXT ("This program requires Windows NT!"),szAppName, MB_ICONERROR) ;
     }
     return 0 ;
}

BOOL PopFileOpenDlg (HWND hwnd, PTSTR pstrFileName, PTSTR pstrTitleName,TCHAR szFilter[])
{
	static OPENFILENAME ofn ;
     
     ofn.lStructSize       = sizeof (OPENFILENAME) ;
     ofn.hwndOwner         = hwnd ;
     ofn.hInstance         = NULL ;
     ofn.lpstrFilter       = szFilter ;
     ofn.lpstrCustomFilter = NULL ;
     ofn.nMaxCustFilter    = 0 ;
     ofn.nFilterIndex      = 0 ;
     ofn.nMaxFile          = MAX_PATH ;
     ofn.nMaxFileTitle     = MAX_PATH ;
     ofn.lpstrInitialDir   = NULL ;
     ofn.lpstrTitle        = NULL ;
     ofn.nFileOffset       = 0 ;
     ofn.nFileExtension    = 0 ;
     ofn.lpstrDefExt       = NULL;
     ofn.lCustData         = 0L ;
     ofn.lpfnHook          = NULL ;
     ofn.lpTemplateName    = NULL ;
     ofn.lpstrFile         = pstrFileName ;
     ofn.lpstrFileTitle    = pstrTitleName ;
     ofn.Flags             = OFN_HIDEREADONLY | OFN_CREATEPROMPT ;
     return GetOpenFileName (&ofn) ;
}

BOOL PopFileSaveDlg (HWND hwnd, PTSTR pstrFileName, PTSTR pstrTitleName,TCHAR szFilter[])
{
	static OPENFILENAME ofn ;
     
     ofn.lStructSize       = sizeof (OPENFILENAME) ;
     ofn.hwndOwner         = hwnd ;
     ofn.hInstance         = NULL ;
     ofn.lpstrFilter       = szFilter ;
     ofn.lpstrCustomFilter = NULL ;
     ofn.nMaxCustFilter    = 0 ;
     ofn.nFilterIndex      = 0 ;
     ofn.nMaxFile          = MAX_PATH ;
     ofn.nMaxFileTitle     = MAX_PATH ;
     ofn.lpstrInitialDir   = NULL ;
     ofn.lpstrTitle        = NULL ;
     ofn.nFileOffset       = 0 ;
     ofn.nFileExtension    = 0 ;
     ofn.lpstrDefExt       = TEXT("qcif");
     ofn.lCustData         = 0L ;
     ofn.lpfnHook          = NULL ;
     ofn.lpTemplateName    = NULL ;
     ofn.lpstrFile         = pstrFileName ;
     ofn.lpstrFileTitle    = pstrTitleName ;
     ofn.Flags             = OFN_OVERWRITEPROMPT;
     return GetSaveFileName (&ofn) ;
}

void Printf (HWND hwnd, TCHAR * szFormat, ...)
{
     TCHAR   szBuffer [1024] ;
     va_list pArgList ;

     va_start (pArgList, szFormat) ;
     wvsprintf (szBuffer, szFormat, pArgList) ;
     va_end (pArgList) ;

     SendMessage (hwnd, EM_SETSEL, (WPARAM) -1, (LPARAM) -1) ;
     SendMessage (hwnd, EM_REPLACESEL, FALSE, (LPARAM) szBuffer) ;
     SendMessage (hwnd, EM_SCROLLCARET, 0, 0) ;
}


BOOL CALLBACK DlgProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static FILEDATA files;
	static RECT rect; 
     static HWND         hwndEdit1,hwndEdit6;
	 static HWND         hinput,houtput,hqcif,hcif,hwidth,hheight,hhscrol;
	 static HWND         hstart,hend,houtbut,hconvert;
     static OPENFILENAME ofn ;
     static TCHAR        szFileName [MAX_PATH], szTitleName [MAX_PATH] ;
	 static TCHAR szFilter[] = TEXT ("AVI Files (*.avi)\0*.avi\0")
                               TEXT ("All Files (*.*)\0*.*\0\0") ;
     static TCHAR szFileName2[MAX_PATH], szTitleName2[MAX_PATH] ;
 	 static TCHAR szFilter2[] = TEXT ("QCIF Files (*.qcif)\0*.qcif\0")
								TEXT ("CIF Files (*.cif)\0*.cif\0")
                               TEXT ("All Files (*.*)\0*.*\0\0") ;

	 static HDRAWDIB hdd;
	 HDC hdc;
     PAINTSTRUCT               ps ;
	 unsigned int i,start,end,W,H;
	 static FILE *pfqcif=NULL;
	 static long framepos;
	 

	switch (message)
	{
	     case WM_INITDIALOG:
			framepos=0;
			 ghwnd=hwnd;
			hdd=DrawDibOpen();
			files.pmydib = new MYDIB();

			 initFILEDATA(&files);
			   AVIFileInit();          // opens AVIFile library 

			hwndEdit1=GetDlgItem(hwnd,IDC_EDIT1);
			hwndEdit6=GetDlgItem(hwnd,IDC_EDIT6);
			hinput=GetDlgItem(hwnd,IDC_EDIT2);
			houtput=GetDlgItem(hwnd,IDC_EDIT3);
			hstart=GetDlgItem(hwnd,IDC_EDIT7);
			hend=GetDlgItem(hwnd,IDC_EDIT8);
			hqcif=GetDlgItem(hwnd,IDC_RADIO1);
			hcif=GetDlgItem(hwnd,IDC_RADIO2);
			hwidth=GetDlgItem(hwnd,IDC_EDIT4);
			hheight=GetDlgItem(hwnd,IDC_EDIT5);
			houtbut=GetDlgItem(hwnd,IDC_BUTTON2);
			hhscrol=GetDlgItem(hwnd,IDC_SCROLLBAR1);
			hconvert=GetDlgItem(hwnd,IDC_BUTTON3);
			
			// Center the window on screen

          GetWindowRect (hwnd, &rect) ;
          SetWindowPos (hwnd, NULL, 
               (GetSystemMetrics (SM_CXSCREEN) - rect.right + rect.left) / 2,
               (GetSystemMetrics (SM_CYSCREEN) - rect.bottom + rect.top) / 2,
               0, 0, SWP_NOZORDER | SWP_NOSIZE) ;
		  
		  
		  SetWindowText(hstart,"0");
		  SetWindowText(hend,"0");
  		  EnableWindow(hstart,FALSE);
		  EnableWindow(hend,FALSE);
		  EnableWindow(hconvert,FALSE);

  		  EnableWindow(hwidth,FALSE);
		  EnableWindow(hheight,FALSE);
		  EnableWindow(houtbut,FALSE);
		  EnableWindow(hhscrol,FALSE);
		  EnableWindow(hqcif,FALSE);
		  EnableWindow(hcif,FALSE);
		  SendMessage(hqcif,BM_SETCHECK,1,0);

	
          return TRUE ;
		 case WM_PAINT:
			 
           hdc = BeginPaint (hwnd, &ps) ;

		   if(files.bitmapInfo!=NULL && files.aviFile ==TRUE)
			   DrawDibDraw(hdd,hdc,250,270,150,122,(LPBITMAPINFOHEADER)files.pmydib->Info, 
								  files.pmydib->GetBits(),0,0,files.pmydib->W,files.pmydib->H,
                                  DDF_SAME_HDC  ) ;

			 
          EndPaint (hwnd, &ps) ;
			 return FALSE;
		 case WM_HSCROLL:
			 switch(LOWORD(wParam))
			 {
			 case SB_LINELEFT:
				 framepos--;
				 break;
			 case SB_LINERIGHT:
				 framepos++;
				 break;
			 case SB_PAGELEFT:
				 framepos-=(files.videoInfo.dwLength/5);
				 break;
 			 case SB_PAGERIGHT:
				 framepos+=(files.videoInfo.dwLength)/5;
				 break;
			 case SB_THUMBTRACK:
				 framepos=HIWORD(wParam);
				 break;
			 default:
				 break;
			 }
			
			framepos=max(0,min(files.videoInfo.dwLength-1,framepos));
			SetScrollPos(hhscrol,SB_CTL,framepos,TRUE);
			SetDlgItemInt(hwnd,IDC_STATIC1,framepos,FALSE);
			getFrame(&files,framepos);
			InvalidateRect(hwnd,NULL,false);
			return TRUE;

	 case WM_COMMAND:
		 switch(LOWORD(wParam))
		 {
		 case IDC_BUTTON1:
			 if(!PopFileOpenDlg (hwnd,szFileName,szTitleName,szFilter))
			 return 0;
			 if(files.aviFile==TRUE){
				 if(CloseAVI(&files)){
					files.aviFile=FALSE;				 
				 }
			 };
			 strcpy(files.fileName,szFileName); 
			 if(OpenAVI(&files)){
				files.aviFile=TRUE;
				getFrame(&files,0);
			 }
			 else{
				 szFileName[0]='\0';
				 szTitleName[0]='\0';

				return 0;
			 }
				 
			 SetWindowText(hinput,szFileName);
     		Printf (hwndEdit1,"%s%s",szTitleName,"\n");
			Printf (hwndEdit1,"Width:%d\n",files.videoInfo.rcFrame.right );
			Printf (hwndEdit1,"Heigth:%d\n",files.videoInfo.rcFrame.bottom );
			Printf (hwndEdit1,"Scale:%d\n",files.videoInfo.dwScale);
			Printf (hwndEdit1,"Rate:%d\n",files.videoInfo.dwRate);
			Printf (hwndEdit1,"Length:%d\n",files.videoInfo.dwLength);
			Printf (hwndEdit1,"---------------------\n");
			

				EnableWindow(houtbut,TRUE);
				EnableWindow(hhscrol,TRUE);

				SetScrollRange(hhscrol,SB_CTL,0,files.videoInfo.dwLength-1,FALSE);
				SetScrollPos(hhscrol,SB_CTL,0,TRUE);
				
				InvalidateRect(hwnd,NULL,false);

			 return TRUE;
 		 case IDC_BUTTON2:
 			 if(!PopFileSaveDlg (hwnd,szFileName2,szTitleName2,szFilter2))
			 {
			 return 0;
			 }
			 pfqcif=fopen(szFileName2,"wb");
			 if(pfqcif==NULL){
				DisplayMBox("Save File Error","Can't Open save filename!");
				return 0;
			 }
 			 SetWindowText(houtput,szFileName2);
 	  			EnableWindow(hstart,TRUE);
				EnableWindow(hend,TRUE);
				EnableWindow(hconvert,TRUE);
				EnableWindow(hqcif,TRUE);
				EnableWindow(hcif,TRUE);

				SetWindowText(hwidth,"176");
				SetWindowText(hheight,"144");



			 return TRUE;
		 case IDC_BUTTON3:
			 if(pfqcif!=NULL)
			 {
				 start=GetDlgItemInt(hwnd,IDC_EDIT7,NULL,false);
				 end=GetDlgItemInt(hwnd,IDC_EDIT8,NULL,false);
				 W=GetDlgItemInt(hwnd,IDC_EDIT4,NULL,false);
				 H=GetDlgItemInt(hwnd,IDC_EDIT5,NULL,false);
				 if(start <0 || start > (files.videoInfo.dwLength-1) || end <0 || end >(files.videoInfo.dwLength-1) || start > end){
				DisplayMBox("Range Error!!","Something Worng Error!");
				return 0;
				 }
				

				 SetCursor(LoadCursor(NULL, IDC_WAIT));
				ShowCursor(TRUE);


	      		Printf (hwndEdit6,"%s\n","Start processing frame ...");
				 for(i=start;i<=end;i++)
				 {
		      		Printf (hwndEdit6,"%s%d\n","Processing frame ",i);
					  files.bitmapInfo = (BITMAPINFO *) AVIStreamGetFrame(files.pgf, i);
					  if(files.bitmapInfo!=NULL){
					  files.pmydib->convert(files.bitmapInfo ,W,H);
  					  fwrite(files.pmydib ->neworgframe[0],1,(W*H),pfqcif) ;
					  fwrite(files.pmydib->neworgframe[1],1,(W*H)/4,pfqcif);
					fwrite(files.pmydib->neworgframe[2],1,(W*H)/4,pfqcif) ;
					  }
					  else return 0;
				 }
				 if(pfqcif!=NULL){
					 fclose(pfqcif);
					 pfqcif=NULL;
				 }
 	      		Printf (hwndEdit6,"%s\n","Convert complete");
				ShowCursor(FALSE);
   			 SetCursor(LoadCursor(NULL, IDC_ARROW));
	   		  EnableWindow(hstart,FALSE);
			  EnableWindow(hend,FALSE);
			  EnableWindow(hconvert,FALSE);

  			  EnableWindow(hwidth,FALSE);
			EnableWindow(hheight,FALSE);
			  EnableWindow(hqcif,FALSE);
			  EnableWindow(hcif,FALSE);

			 }
						 
			 return TRUE;

		 case IDC_RADIO1:
		 case IDC_RADIO2:
			 CheckRadioButton(hwnd,IDC_RADIO1,IDC_RADIO2,LOWORD(wParam));
			 switch(LOWORD(wParam))
			 {
			 case IDC_RADIO1:
 				SetWindowText(hwidth,"176");
				SetWindowText(hheight,"144");
				break;

			 case IDC_RADIO2:
 				SetWindowText(hwidth,"352");
				SetWindowText(hheight,"288");
				break;
			 }

			 return TRUE;
			 
		 case IDCANCEL:
		 case IDOK:
			 DrawDibClose(hdd);
			 delete	files.pmydib;
	 		AVIFileExit();			// releases AVIFile library 			
		   if(files.aviFile==TRUE) CloseAVI(&files);
		    if(pfqcif!=NULL)fclose(pfqcif);
		     EndDialog (hwnd, 0) ;
			 return TRUE ;
		 }
                   
          break ;
     }
     return FALSE ;
}


void initFILEDATA(FILEDATA *files)
{
	files->pfile=NULL;
	files->pavi_video=NULL;
	files->pgf=NULL;
	files->aviFile =FALSE;

}
bool OpenAVI(FILEDATA *files)
{


  if (!files->pfile)
  {
    if (AVIFileOpen(&files->pfile, files->fileName, OF_READ, NULL))
    {
      files->pfile = NULL;
      sprintf(errortext,"Could not open %s.", files->fileName);
      DisplayMBox(errortext, "open AVI error");
      return false;
    }

    if (!AVIFileGetStream(files->pfile, &files->pavi_video, streamtypeVIDEO, 0))
    {
      if (AVIStreamInfo(files->pavi_video, &files->videoInfo, sizeof(files->videoInfo)))
      {
        sprintf(errortext,"Could not get video stream info from %s.", files->fileName);
        DisplayMBox(errortext, "open AVI error");
        return false;
      }
      files->pgf = AVIStreamGetFrameOpen(files->pavi_video, NULL);
      if (files->pgf == NULL)
      {
        sprintf(errortext,"Could not open getframe from %s, compressor = %c%c%c%c.", files->fileName,
                                                  (char) (files->videoInfo.fccHandler & 0x000000ff),
                                                  (char) ((files->videoInfo.fccHandler & 0x0000ff00) >> 8),
                                                  (char) ((files->videoInfo.fccHandler & 0x00ff0000) >> 16),
                                                  (char) ((files->videoInfo.fccHandler & 0xff000000) >> 24));
        DisplayMBox(errortext, "open AVI error");
        return false;
      }
    }
    else
      files->pavi_video = NULL;
	if ((!files->pavi_video))
    {
      sprintf(errortext, "%s does not contain any supported streams", files->fileName);
      DisplayMBox(errortext, "open AVI error");
      return false;
    }
  }
  return true;
}

bool CloseAVI(FILEDATA *files)
{
    if(files->pgf!=NULL)
	AVIStreamGetFrameClose(files->pgf);
    if(files->pfile!=NULL)
    AVIFileRelease(files->pfile);  // closes the file 
	initFILEDATA(files);
	return TRUE;
}



bool ResizeFrame(FILEDATA *files,int cx,int cy)
{

	if(files->aviFile!=NULL && files->bitmapInfo!=NULL)
	{
		//if(files->pmydib->convert(files->bitmapInfo,cx,cy))
			if(files->pmydib->Rescale (cx,cy,cx,cy))
		return TRUE;
	}

  sprintf(errortext, "%s resize frames error!", files->fileName);
  DisplayMBox(errortext, "open AVI error");
  return false;

}


bool getFrame(FILEDATA *files,long currentOPos)
{
  
  
    if (files->aviFile!=NULL)
    {
      files->bitmapInfo = (BITMAPINFO *) AVIStreamGetFrame(files->pgf, currentOPos);
      if (files->bitmapInfo == NULL)
      {
		sprintf(errortext, "Read %s at %d frame error!", files->fileName,currentOPos);
		DisplayMBox(errortext, "Read AVI Frame error");
		return false;
	  }
	  if(!files->pmydib->LoadFromBMP (files->bitmapInfo))
	  {
		sprintf(errortext, "Move frame to memory %s at %d frame error!", files->fileName,currentOPos);
		DisplayMBox(errortext, "Read AVI Frame error");
		return false;


	  }

    }
	else
	{
	  sprintf(errortext, "%s does not contain any supported streams", files->fileName);
      DisplayMBox(errortext, "open AVI error");
      return false;
	}
  return TRUE;
}

int DisplayMBox(char *txt, char *title)
{
  char tempStr[80];

  if (strlen(title))
    sprintf(tempStr, "%s - %s",txt, title);
  else
    strcpy(tempStr, szAppName);
  return MessageBox(ghwnd,txt, tempStr, MB_OK);
}

